<?php
/**
 * Exchange Resets
 * https://webenginecms.org/
 * 
 * @version 1.2.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2020 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

if(!isLoggedIn()) redirect(1,'login');

echo '<div class="page-title"><span>'.lang('exchangeresets_title').'</span></div>';

try {
	
	$ExchangeResets = new \Plugin\ExchangeResets\ExchangeResets();
	
	$Character = new Character();
	$AccountCharacters = $Character->AccountCharacter($_SESSION['username']);
	if(!is_array($AccountCharacters)) throw new Exception(lang('exchangeresets_error_5'));
	
	echo '<table class="table general-table-ui">';
		echo '<tr>';
			echo '<td></td>';
			echo '<td>'.lang('exchangeresets_txt_1').'</td>';
			echo '<td>'.lang('exchangeresets_txt_4').'</td>';
			echo '<td>'.lang('exchangeresets_txt_2').'</td>';
			echo '<td></td>';
		echo '</tr>';
		
		foreach($AccountCharacters as $thisCharacter) {
			$characterData = $Character->CharacterData($thisCharacter);
			$characterIMG = $Character->GenerateCharacterClassAvatar($characterData[_CLMN_CHR_CLASS_]);
			
			// exchanged resets
			$exchangedResets = $ExchangeResets->getExchangedResetsFromCharacter($characterData[_CLMN_CHR_NAME_]);
			if(!check_value($exchangedResets)) {
				$exchangedResets = 0;
			}
			
			// available exchanges
			$availableExchanges = $characterData[_CLMN_CHR_RSTS_]-$exchangedResets;
			
			echo '<tr>';
				echo '<td>'.$characterIMG.'</td>';
				echo '<td>'.$characterData[_CLMN_CHR_NAME_].'</td>';
				echo '<td>'.number_format($characterData[_CLMN_CHR_RSTS_]).'</td>';
				echo '<td>'.number_format($exchangedResets).'</td>';
				echo '<td><a href="'.__EXCHANGERESETS_HOME__.'exchange/character/'.$characterData[_CLMN_CHR_NAME_].'/" class="btn btn-primary">'.lang('exchangeresets_txt_6',true).'</a></td>';
			echo '</tr>';
		}
	echo '</table>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}